/* 
 *  UserDetailsForm.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient;

import javafx.collections.ObservableList;

public class UserDetailsForm extends DetailsForm {

    private static final Logger LOG = Logger.getLogger(UserDetailsForm.class);
    private final UserDataGUI userDataGUI;
    private final UserExecutor userExe;

    public UserDetailsForm(UserExecutor userExe, String css, UserDataGUI userDataGUI) {
        super(LOG, "User Details", "User Details", css);
        this.userExe = userExe;
        this.userDataGUI = userDataGUI;
    }

    @Override
    protected void action(){
        userExe.getUserData();
    }
    
    @Override
    protected ObservableList<Data> getItems(){
        return userDataGUI.getItems();
    }
    
    @Override
    protected Data getItem(String id){
        return userDataGUI.getUser(id);
    }

    @Override
    protected Data getDefault() {
        return new UserData(null);
    }
    
}
